class RequestItem {
  String? id;
  String? userId;
  String? item;
  String? trackId;
  dynamic quality;
  String? recommend;
  String? imagePath;
  String? overview;
  String? status;
  String? isPublish;
  String? createdAt;
  String? updatedAt;
  String? upVotes;
  String? downVotes;
  String? userVote;
  String? userSubscribe;
  List<ItemSubscribe>? itemSubscribes;

  RequestItem({
    this.id,
    this.userId,
    this.item,
    this.trackId,
    this.quality,
    this.recommend,
    this.imagePath,
    this.overview,
    this.status,
    this.isPublish,
    this.createdAt,
    this.updatedAt,
    this.upVotes,
    this.downVotes,
    this.userVote,
    this.userSubscribe,
    this.itemSubscribes,
  });

  factory RequestItem.fromJson(Map<String, dynamic> json) => RequestItem(
        id: json["id"]?.toString(),
        userId: json["user_id"]?.toString(),
        item: json["item"]?.toString(),
        trackId: json["track_id"]?.toString(),
        quality: json["quality"]?.toString(),
        recommend: json["recommend"]?.toString(),
        imagePath: json["image_path"]?.toString(),
        overview: json["overview"]?.toString(),
        status: json["status"]?.toString(),
        isPublish: json["is_publish"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        upVotes: json["upvotes"]?.toString(),
        downVotes: json["downvotes"]?.toString(),
        userVote: json["user_vote"]?.toString(),
        userSubscribe: json["user_subscribe"]?.toString(),
        itemSubscribes: json["item_subscribes"] == null ? [] : List<ItemSubscribe>.from(json["item_subscribes"]!.map((x) => ItemSubscribe.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "item": item,
        "track_id": trackId,
        "quality": quality,
        "recommend": recommend,
        "image_path": imagePath,
        "overview": overview,
        "status": status,
        "is_publish": isPublish,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "upvotes": upVotes,
        "downvotes": downVotes,
        "user_vote": userVote,
        "user_subscribe": userSubscribe,
        "item_subscribes": itemSubscribes == null ? [] : List<dynamic>.from(itemSubscribes!.map((x) => x.toJson())),
      };

  RequestItem copyWith({
    String? id,
    String? userId,
    String? item,
    String? trackId,
    dynamic quality,
    String? recommend,
    String? imagePath,
    String? overview,
    String? status,
    String? isPublish,
    String? createdAt,
    String? updatedAt,
    String? upVotes,
    String? downVotes,
    String? userVote,
    String? userSubscribe,
    List<ItemSubscribe>? itemSubscribes,
  }) {
    return RequestItem(
      id: id ?? this.id,
      userId: userId ?? this.userId,
      item: item ?? this.item,
      trackId: trackId ?? this.trackId,
      quality: quality ?? this.quality,
      recommend: recommend ?? this.recommend,
      imagePath: imagePath ?? this.imagePath,
      overview: overview ?? this.overview,
      status: status ?? this.status,
      isPublish: isPublish ?? this.isPublish,
      createdAt: createdAt ?? this.createdAt,
      updatedAt: updatedAt ?? this.updatedAt,
      upVotes: upVotes ?? this.upVotes,
      downVotes: downVotes ?? this.downVotes,
      userVote: userVote ?? this.userVote,
      userSubscribe: userSubscribe ?? this.userSubscribe,
      itemSubscribes: itemSubscribes ?? this.itemSubscribes,
    );
  }
}

class ItemSubscribe {
  String? id;
  String? userId;
  String? requestItemId;
  String? createdAt;
  String? updatedAt;

  ItemSubscribe({
    this.id,
    this.userId,
    this.requestItemId,
    this.createdAt,
    this.updatedAt,
  });

  factory ItemSubscribe.fromJson(Map<String, dynamic> json) => ItemSubscribe(
        id: json["id"]?.toString(),
        userId: json["user_id"]?.toString(),
        requestItemId: json["request_item_id"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "request_item_id": requestItemId,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };

  ItemSubscribe copyWith({
    String? id,
    String? userId,
    String? requestItemId,
    String? createdAt,
    String? updatedAt,
  }) {
    return ItemSubscribe(
      id: id ?? this.id,
      userId: userId ?? this.userId,
      requestItemId: requestItemId ?? this.requestItemId,
      createdAt: createdAt ?? this.createdAt,
      updatedAt: updatedAt ?? this.updatedAt,
    );
  }
}
